#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/types.h>   
#include <sys/socket.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <linux/sockios.h>
#include <sys/ioctl.h>
#include <stdarg.h>

#define DEBUG_FILE_PATH "/tmp/dhcp.debug"

#define MAX_DEBUG_MESSAGE 500
#define MAX_MSG_LEN 1024

static int debug_message = 0;

void debug_to_console(const char* cmd, ...)
{
	char buf[2048] = {0};
	char buf1[2048] ={0};
	va_list vaList;
	va_start (vaList, cmd);
	vsprintf (buf, cmd, vaList);
	va_end (vaList);

	snprintf(buf1, sizeof(buf1), "echo \"%s\" > /dev/console", buf);
	system(buf1);
}

/* only to be used by debug.h */
void debug_to_file(const char *cmd, ...) 
{
	if ((debug_message % MAX_DEBUG_MESSAGE) == 0)
	{
		/* to avoid too many debug messages */
		unlink(DEBUG_FILE_PATH);
	}
	
	debug_message++;
	static char buf[MAX_MSG_LEN] = {0};
	memset(buf, 0, sizeof(buf));
	va_list vaList;
	va_start(vaList, cmd);
    vsnprintf(buf, MAX_MSG_LEN, cmd, vaList);
    va_end(vaList);


	time_t cur_time = time(NULL);
	char *time_str = ctime(&cur_time);

	/* strip '\n' */
	time_str[strlen(time_str) - 1] = 0;
	
	
	FILE *fp = fopen(DEBUG_FILE_PATH, "a+");
	
	if (fp)
	{
		fprintf(fp, "%s file debug %d : %s\n", time_str, debug_message, buf);
		fclose(fp);
	}
}